import LicenseSpring

import SwiftUI

struct ContentView: View {
    @State private var manager: LicenseManager?
    @State private var bundleManager: BundleManager?
    @State private var floatingClient: FloatingClient?
    @State private var managerType: ManagerType = .licenseManager
    @State private var configSheetPresented = true
    @State private var logs: [String] = []
    
    @EnvironmentObject private var viewUpdater: ViewUpdaterHack
    
    var body: some View {
        VStack {
            switch managerType {
            case .licenseManager:
                if let license = manager?.currentLicense {
                    LicenseView(manager: manager, license: license, isVM: (manager?.configuration.isVM ?? false && ((manager?.configuration.isVMDetectionEnabled) != nil)))
                } else {
                    InitialView(manager: manager, bundleManager: bundleManager, showConfiguration: $configSheetPresented)
                }
            case .floatingClient:
                if let license = floatingClient?.currentLicense {
                    LicenseView(manager: floatingClient, license: license, isVM: (floatingClient?.configuration.isVM ?? false && ((floatingClient?.configuration.isVMDetectionEnabled) != nil)))
                } else {
                    InitialFloatingClientView(manager: floatingClient, showConfiguration: $configSheetPresented)
                }
            }
            GroupBox(label: Text("Logs")) {
                if !logs.isEmpty{
                    ScrollView {
                        ForEach(logs, id: \.self) {
                            Text($0)
                                .frame(maxWidth: .infinity, alignment: .leading)
                        }
                    }
                    .frame(maxWidth: .infinity, maxHeight: 100)
                }
            }
            .padding([.horizontal, .bottom])
            .onAppear {
                LSLog.log = { level, message in
                    let text = "[\(level.rawValue.uppercased())] \(message())"
                    Task{ @MainActor in
                        logs.append(text)
                    }
                }
            }
        }
        .frame(width: size.width, height: size.height)
        .sheet(
            isPresented: $configSheetPresented,
            onDismiss: { configSheetPresented = manager == nil && floatingClient == nil
            }
        ) {
            ConfigView(managerType: $managerType) { config in
                guard let config else { exit(0) }
                switch managerType {
                case .licenseManager:
                    manager = try LicenseManager(configuration: config)
                    bundleManager = try BundleManager(configuration: config)
                case .floatingClient:
                    floatingClient = try FloatingClient(configuration: config)
                }
                configSheetPresented = false
            }
            .frame(minWidth: 500)
            .padding()
        }
    }
    
    private var size: CGSize {
        if manager?.currentLicense != nil || floatingClient?.currentLicense != nil {
            return CGSize(width: 1200, height: 800)
        } else {
            return CGSize(width: 800, height: 800)
        }
    }
}

struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
            .environmentObject(ViewUpdaterHack.shared)
    }
}
